go
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_analise')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_analise
END
go

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_excesso')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_excesso
END
go

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_tbl_a')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_tbl_a
END
go

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_tbl_v')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_tbl_v
END
go
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_base2')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_base2
END
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_ANALISE_DIARIO_base')
BEGIN
	DROP TABLE EST_PROD_CPL_ANALISE_DIARIO_base
END


/*************************************************************************************************************************************/
go

CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_analise (CD_EMP 				INT,
													CD_FILIAL			INT,
													DT_VD				DATETIME,
													CD_PROD				INT,
													PART_QTDE			FLOAT,
													QT_VD_DIA			MONEY,
													QT_MEDIA_VD			MONEY,
													PART_VLR			FLOAT,
													VLR_MEDIO_VD		MONEY,
													COBERTURA			MONEY,
													QT_EST				MONEY,
													QT_EXCESSO			MONEY,
													LIMITE_EXCESSO		MONEY,
													FLAG_PART_INDIC		MONEY,
													QT_EST_EM_TERC		MONEY,	
													QT_EST_DE_TERC		MONEY,	
													QT_EST_DEPOSITOS	MONEY,
													MEDIAF				MONEY,
													QT_PEND_ENT			MONEY,
													QT_PEND_SAI			MONEY,
													QT_RESSUP_DIA		MONEY,
													QT_CP_DIA			MONEY,
													CD_SIGLA			INT,
													VLR_DESC_VD			MONEY,
													QT_DIAS_EXCESSO		MONEY,
													QT_RESSUP_PROX_DIA	MONEY, 
													CD_FABRIC				INT,
													CD_ARV_MERC_LINHA		INT,
													COMPRA_POR_SUPRIMENTO	INT,
													LJ_FLAG_PARTIC_INDIC	INT,
													FLAG_ANALISE_FALTAS		INT,
													STS_PROD_EMP			INT,
													STS_PROD_FILIAL			INT,
													EMAX					MONEY,
													ESEG					MONEY,
													QTDE_FACEAMENTO			MONEY,
													QTDE_FINANCIADO			MONEY,
													QTDE_LIMITADOR			MONEY,
													VLR_CUSTO				MONEY,
													VLR_CUSTO_MD			MONEY,
													VLR_TABELA				MONEY,
													VLR_OFERTA				MONEY,
													FLAG_NAO_PARTIC_INDIC_LINHA INT
													 CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_analise] 
														PRIMARY KEY CLUSTERED (CD_PROD, CD_FILIAL, CD_EMP)
													 );
go					
CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_excesso (CD_EMP					INT, 
													CD_FILIAL				INT, 
													DT_ATUAL				DATETIME, 
													CD_PROD					INT, 
													CURVA					VARCHAR(5), 
													MEDIAF					MONEY, 
													COBERTURA				MONEY,
													QT_EST					MONEY, 
													QTDE_EXCESSO			MONEY,
													EMAX 					MONEY,
				 									QT_EST_EM_TERC			MONEY,	
													QT_EST_DE_TERC			MONEY,	
													QT_EST_DEPOSITOS		MONEY,
													QTDE_MEDIAF				MONEY,
													QT_PEND_ENT				MONEY,
													QT_PEND_SAI				MONEY,	
													QT_DIAS_EXCESSO			MONEY
													 CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_excesso] 
														PRIMARY KEY CLUSTERED (CD_PROD, CD_FILIAL, CD_EMP) );
go
CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_tbl_a ( CD_PROD		INT, 
													PART_QTDE	FLOAT,
													QT_MEDIA_VD	MONEY,
													PART_VLR	FLOAT
													CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_tbl_a] 
														PRIMARY KEY CLUSTERED (CD_PROD) );
go
CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_tbl_v ( CD_PROD			INT,
												QTDE_IT			MONEY,
												VLR_TOTAL_VD	MONEY,
												VLR_DESC_VD		MONEY
												CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_tbl_v] 
														PRIMARY KEY CLUSTERED (CD_PROD));

go
CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_base2	(	CD_CTR INT IDENTITY(1,1),
													     CD_FILIAL		INT,
														CD_PROD			INT,
														QT_DIAS_CALCULO	MONEY,
														QT_DIAS_FALTA	MONEY
														CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_base2] 
															 PRIMARY KEY CLUSTERED (CD_CTR));

go
CREATE TABLE EST_PROD_CPL_ANALISE_DIARIO_base	(	CD_FILIAL		INT,
													CD_PROD			INT,
													QT_DIAS_CALCULO	MONEY,
													QT_DIAS_FALTA	MONEY
													CONSTRAINT [PK_EST_PROD_CPL_ANALISE_DIARIO_base] 
														PRIMARY KEY CLUSTERED (CD_PROD,CD_FILIAL));

go
/*************************************************************************************************************************************/

/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30]    Script Date: 01/27/2014 18:18:50 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30]
GO
  
/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30]    Script Date: 01/27/2014 18:18:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO 
-- exec P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30 1,1,'2012-09-04',504
-- Versao 2800
CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30]
						@CD_EMP INT=1, 
						@QT_MESES INT=1, 
						@DT_ATUAL DATETIME=NULL,
						@CD_FILIAL INT 
AS
SET NOCOUNT ON
 

DECLARE @FLAGCONTROLETIPOCOMPRAFILIAL INT

SET @FLAGCONTROLETIPOCOMPRAFILIAL=ISNULL((SELECT 
												VALOR AS ORC_PED_CP
											  FROM 
													PRC_EMP_CONFIG
											  WHERE 
													CD_EMP	= @CD_EMP 
													AND	CD_CHAVE = 'FLAG_CONTROLE_TIPO_COMPRA_FILIAL'),0);
DECLARE 
		@DT_BASE DATETIME, 
		@ANO_INI INT, 
		@MES_INI INT, 
		@ANO_FIM INT, 
		@MES_FIM INT, 
		@INI INT, 
		@FIM INT,
		@DT_INI_MES DATETIME, 
		@DT_FIM_MES DATETIME;
/*********************************************************************************************************************************************/


	truncate table EST_PROD_CPL_ANALISE_DIARIO_analise;
	truncate table EST_PROD_CPL_ANALISE_DIARIO_excesso;
	truncate table EST_PROD_CPL_ANALISE_DIARIO_tbl_a;
	truncate table EST_PROD_CPL_ANALISE_DIARIO_tbl_v;
	truncate table EST_PROD_CPL_ANALISE_DIARIO_base2;
	truncate table EST_PROD_CPL_ANALISE_DIARIO_base; 

/*********************************************************************************************************************************************/

--Calculo do periodo de analise
IF @DT_ATUAL IS NULL SELECT @DT_ATUAL=dbo.F_ONTEM();
 
	SELECT	@DT_BASE=DATEADD(mm, -1, @DT_ATUAL ),
			@ANO_FIM=YEAR(@DT_BASE),	@MES_FIM=MONTH(@DT_BASE), 
			@ANO_INI=@ANO_FIM,			@MES_INI=@MES_FIM-@QT_MESES+1;
	WHILE @MES_INI<=0 
		SELECT @MES_INI=@MES_INI+12,	@ANO_INI=@ANO_INI-1;

	SELECT 
		@INI=@ANO_INI*100+@MES_INI,	
		@FIM=@ANO_FIM*100+@MES_FIM;  

-----------------------------------------------------------------------------------------------------------------------		
		 
	--Limpa eventual dado previo do dia
	DELETE 
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO 
	WHERE 
	     CD_EMP=@CD_EMP  
		AND CD_FILIAL = @CD_FILIAL
		AND DT_VD=@DT_ATUAL ;
 
-----------------------------------------------------------------------------------------------------------------------
	----Processando faltas 

	PRINT 'INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_tbl_a' + CONVERT(VARCHAR,GETDATE())
	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_tbl_a
	SELECT	
		c.CD_PROD, 
		PART_QTDE   = CONVERT(FLOAT, (SUM(isnull(a.PART_QTDE,0)) / @QT_MESES)),
		QT_MEDIA_VD = CONVERT(FLOAT, (SUM(isnull(a.QTDE_TOTAL,0))/ @QT_MESES)),
		PART_VLR    = CONVERT(FLOAT, (SUM(isnull(a.PART_VLR,0))  / @QT_MESES))
	FROM 
		EST_PROD_CPL c
		LEFT JOIN EST_PROD_CPL_ANALISE_30 A ON 
		C.CD_EMP	= A.CD_EMP AND
		C.CD_FILIAL = A.CD_FILIAL
		AND C.CD_PROD	= A.CD_PROD AND
	     A.DT_MOV = @DT_ATUAL 
		
			 
	WHERE 
		c.CD_EMP=@CD_EMP 
		AND c.CD_FILIAL=@CD_FILIAL 
	GROUP BY c.CD_PROD;

-----------------------------------------------------------------------------------------------------------------------

	PRINT 'INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_tbl_v ' + CONVERT(VARCHAR,GETDATE())	
	 
	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_tbl_v
	SELECT	
		CD_PROD, 
		QTDE_IT      = SUM(PDV_VD_IT.QT_IT),
		VLR_TOTAL_VD = SUM(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT),
		VLR_DESC_VD  = SUM(ROUND(PDV_VD_IT.QT_IT * PDV_VD_IT.VLR_IT * PDV_VD_IT.TX_DESC / 100, 2) + PDV_VD_IT.VLR_OFERTA)
	FROM  PDV_VD INNER JOIN PDV_VD_IT ON
	PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
	PDV_VD.CD_FILIAL =PDV_VD_IT.CD_FILIAL AND
	PDV_VD.CD_VD = PDV_VD_IT.CD_VD AND
	PDV_VD.DT_VD = PDV_VD_IT.DT_VD
	WHERE 
		PDV_VD.CD_EMP=@CD_EMP 
		AND PDV_VD.CD_FILIAL=@CD_FILIAL 
		AND PDV_VD.DT_VD=@DT_ATUAL
		AND PDV_VD.ST_VD = 0
		AND PDV_VD_IT.ST_IT = 1
	GROUP BY PDV_VD_IT.CD_PROD;	

-----------------------------------------------------------------------------------------------------------------------	 
	PRINT 'INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_analise ' + CONVERT(VARCHAR,GETDATE())

	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_analise 
		(CD_EMP,	
		 CD_FILIAL, 
		 DT_VD, 
		 CD_PROD, 
		 PART_QTDE, 
		 QT_VD_DIA, 
		 QT_MEDIA_VD, 
		 PART_VLR, 
		 VLR_MEDIO_VD, 
		 COBERTURA, 
		 QT_EST, 
		 QT_EXCESSO, 
		 LIMITE_EXCESSO,
		 FLAG_PART_INDIC,
    	 QT_EST_EM_TERC,	
		 QT_EST_DE_TERC,	
		 QT_EST_DEPOSITOS,
		 MEDIAF,
		 QT_PEND_ENT,
		 QT_PEND_SAI,
		 QT_RESSUP_DIA,
		 QT_CP_DIA,
		 CD_SIGLA,
		 VLR_DESC_VD, 
		 QT_DIAS_EXCESSO,
		 QT_RESSUP_PROX_DIA,
		 CD_FABRIC,
		 CD_ARV_MERC_LINHA,
		 COMPRA_POR_SUPRIMENTO,
		 LJ_FLAG_PARTIC_INDIC,
		 FLAG_ANALISE_FALTAS,
		 STS_PROD_EMP,
		 STS_PROD_FILIAL,
		 EMAX,
		 ESEG,
		 QTDE_FACEAMENTO,
		 QTDE_FINANCIADO,
		 QTDE_LIMITADOR,
		 VLR_CUSTO,
		 VLR_CUSTO_MD,
		 VLR_TABELA,
		 VLR_OFERTA,
		 FLAG_NAO_PARTIC_INDIC_LINHA)

	SELECT 
		CD_EMP          = @CD_EMP,
		CD_FILIAL       = @CD_FILIAL, 
		DT_VD           = @DT_ATUAL, 
		CD_PROD         = ISNULL(a.CD_PROD, v.CD_PROD),
		PART_QTDE       = ISNULL(a.PART_QTDE, 0), 
		QTDE_IT         = ISNULL(v.QTDE_IT, 0),
		QT_MEDIA_VD     = ISNULL(a.QT_MEDIA_VD, 0),	
		PART_VLR        = ISNULL(a.PART_VLR, 0), 
		VLR_TOTAL_VD    = ISNULL(v.VLR_TOTAL_VD, 0),
		COBERTURA       = NULL, 
		QT_EST          = NULL, 
		QT_EXCESSO      = NULL, 
		LIMITE_EXCESSO  = NULL,
		FLAG_PART_INDIC = NULL,
		QT_EST_EM_TERC	= NULL,	
		QT_EST_DE_TERC	= NULL,	
		QT_EST_DEPOSITOS= NULL,
		MEDIAF			= NULL,
	    QT_PEND_ENT		= NULL,
		QT_PEND_SAI		= NULL,
		QT_RESSUP_DIA	= NULL,
		QT_CP_DIA		= NULL,
		CD_SIGLA		= NULL,
		VLR_DESC_VD		= ISNULL(VLR_DESC_VD,0),
		QT_DIAS_EXCESSO	= NULL,
		QT_RESSUP_PROX_DIA=NULL,
		CD_FABRIC				=NULL,
		CD_ARV_MERC_LINHA		=NULL,
		COMPRA_POR_SUPRIMENTO	=NULL,
		LJ_FLAG_PARTIC_INDIC	=NULL,
		FLAG_ANALISE_FALTAS		=NULL,
		STS_PROD_EMP			=NULL,
		STS_PROD_FILIAL			=NULL,
		EMAX					=NULL,
		ESEG					=NULL,
		QTDE_FACEAMENTO			=NULL,
		QTDE_FINANCIADO			=NULL,
		QTDE_LIMITADOR			=NULL,
		VLR_CUSTO				=NULL,
		VLR_CUSTO_MD			=NULL,
		VLR_TABELA				=NULL,
		VLR_OFERTA				=NULL,
		0 AS FLAG_NAO_PARTIC_INDIC_LINHA
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_tbl_a a 
		FULL OUTER JOIN EST_PROD_CPL_ANALISE_DIARIO_tbl_v v ON 
		a.CD_PROD=v.CD_PROD;

---------------------------------------------------------------------------------------------------------------------------------
	PRINT 'Registra se o produto participa dos indicadores ' + CONVERT(VARCHAR,GETDATE())	  
	--Registra se o produto participa dos indicadores
	IF (DATEADD(DAY, -2, GETDATE()) > @DT_ATUAL)
	BEGIN

		
		CREATE TABLE #RS_RETORNO  (CD_PROD 	INT, QT_IT 	MONEY) 
		CREATE TABLE #RS_SOMA        (CD_PROD INT, QT_IT  MONEY, TIPO TINYINT)
		CREATE TABLE #RS_SUBTRAI     (CD_PROD INT, QT_IT  MONEY, TIPO TINYINT)
		CREATE TABLE #RS_TOT_SUBTRAI (CD_PROD INT, QT_TOT MONEY)
		 
		DECLARE @DT_FECHA DATETIME
		DECLARE @DT_INI DATETIME
		DECLARE @DT_FIM DATETIME

		SET @DT_INI=DBO.F_INICIO_MES(@DT_ATUAL)
		SET @DT_FIM = @DT_ATUAL
		SET @DT_FECHA = DBO.F_INICIO_MES(@DT_ATUAL) -1
		-------------------------------------------------------------------------------
 
		INSERT INTO #RS_SOMA
		SELECT       
			EST_FECHA.CD_PROD,   
			SUM(EST_FECHA.QT_EST),    
			0
		FROM           
			EST_FECHA
		WHERE       
			EST_FECHA.CD_EMP = @CD_EMP   
			AND EST_FECHA.CD_FILIAL = @CD_FILIAL   
			AND EST_FECHA.ANO_FECHA = YEAR(@DT_FECHA)  
			AND EST_FECHA.MES_FECHA = MONTH(@DT_FECHA)  
		GROUP BY EST_FECHA.CD_PROD


		INSERT INTO #RS_SOMA
		SELECT  
			EST_NF_ENT_IT.CD_PROD, 
			SUM(EST_NF_ENT_IT.QT_IT) QT_IT,
			0
		FROM    
			EST_NF_ENT 
			INNER JOIN EST_NF_ENT_IT ON
			EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP AND
			EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND
			EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF AND 
			EST_NF_ENT.DT_ENT = EST_NF_ENT_IT.DT_ENT
			INNER JOIN GLB_MOV_OP ON
			EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
		WHERE   
			EST_NF_ENT_IT.CD_EMP = @CD_EMP 
			AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL
			AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM 
			AND GLB_MOV_OP.ATU_EST = 1
			AND EST_NF_ENT.STS_NF = 0 
			AND GLB_MOV_OP.TP_ESTQ = 0
		GROUP BY EST_NF_ENT_IT.CD_PROD 


		INSERT INTO #RS_SOMA
		SELECT     
			CD_PROD, 
			SUM(QT_IMP),
			0
		FROM 
			EST_PROD_IMP
		WHERE     
			CD_EMP = @CD_EMP 
			AND CD_FILIAL = @CD_FILIAL 
			AND DT_CAD BETWEEN @DT_INI AND @DT_FIM 
			AND TP_EST = 0
		GROUP BY EST_PROD_IMP.CD_PROD  

		-------------------------------------------------------------------------------
 
		INSERT INTO #RS_SUBTRAI
		SELECT     
			I.CD_PROD, 
			SUM(I.QT_IT),
			0
		FROM    
			PDV_VD_IT i 
			INNER JOIN PDV_VD v ON 
			i.CD_EMP=v.CD_EMP AND 
			i.CD_FILIAL=v.CD_FILIAL AND 
			i.CD_VD	= v.CD_VD AND
			i.DT_VD = V.DT_VD
		WHERE   
			v.CD_EMP = @CD_EMP
			AND v.CD_FILIAL = @CD_FILIAL
			AND v.DT_VD BETWEEN @DT_INI AND @DT_FIM 
			and v.ST_VD = 0
			AND I.ST_IT = 1
		GROUP BY I.CD_PROD;


		INSERT INTO #RS_SUBTRAI
		SELECT    	
			CD_PROD, 
			SUM(QT_IT) QT_IT,
			0
		FROM    
			EST_NF_SAI INNER JOIN EST_NF_SAI_IT ON
			EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP AND
			EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
			EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF AND 
			EST_NF_SAI.DT_EMI_NF = EST_NF_SAI_IT.DT_EMI_NF
			INNER JOIN GLB_MOV_OP ON
			EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
		WHERE   
			EST_NF_SAI_IT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
			AND EST_NF_SAI_IT.CD_EMP = @CD_EMP 
			AND EST_NF_SAI_IT.CD_FILIAL = @CD_FILIAL 
			AND GLB_MOV_OP.BX_EST = 1
			AND EST_NF_SAI.STS_NF = 0
			AND GLB_MOV_OP.TP_ESTQ = 0
			AND NOT EXISTS (SELECT 
									CD_NF 
								FROM 
									PDV_VD_EST_NF_SAI
								WHERE
									EST_NF_SAI.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND
									EST_NF_SAI.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND
									EST_NF_SAI.CD_NF = PDV_VD_EST_NF_SAI.CD_NF)
		GROUP BY EST_NF_SAI_IT.CD_PROD;
		 
		--Somando os valores para subtracao 
		INSERT INTO #RS_TOT_SUBTRAI
		SELECT
				CD_PROD
			, SUM(QT_IT)
		FROM
			#RS_SUBTRAI
		GROUP BY
				CD_PROD; 
		INSERT INTO #RS_RETORNO
		SELECT
				CD_PROD
			, SUM(QT_IT)
		FROM
			#RS_SOMA
		GROUP BY CD_PROD;
		-------------------------------
		UPDATE #RS_RETORNO 
		SET  
			QT_IT = RS_RETORNO.QT_IT - ISNULL(RS_TOT_SUBTRAI.QT_TOT,0)
		FROM  
			#RS_RETORNO RS_RETORNO 
			INNER JOIN #RS_TOT_SUBTRAI RS_TOT_SUBTRAI ON
			RS_RETORNO.CD_PROD = RS_TOT_SUBTRAI.CD_PROD;
	 
		-------------------------------
		INSERT INTO #RS_RETORNO
		SELECT
				RS.CD_PROD
			, (RS.QT_TOT * -1)
		FROM
			#RS_TOT_SUBTRAI RS
		WHERE NOT EXISTS( SELECT CD_PROD FROM #RS_RETORNO 
							WHERE CD_PROD = RS.CD_PROD );
/***************************************************************************************************************************************************/

		UPDATE a SET 
			a.FLAG_PART_INDIC	=	p.FLAG_ANALISE_EXC_COB,
			a.QT_EST			=	T.QT_IT,
			a.QT_EST_EM_TERC	=	0,	
			a.QT_EST_DE_TERC	=	0,	
			a.QT_EST_DEPOSITOS	=	CPL.QT_EST_DEPOSITOS,
			a.MEDIAF			=	CPL.MEDIAF,
			a.QT_PEND_ENT		=	0,
			a.QT_PEND_SAI		=	0,
			a.QT_RESSUP_DIA		=	0,
			a.QT_CP_DIA			=	0,
			a.CD_SIGLA			=	CPL.CD_SIGLA,
			A.QT_RESSUP_PROX_DIA=	0,
			A.CD_FABRIC				=p.CD_FABRIC,
			A.CD_ARV_MERC_LINHA		=arv.CD_ARV_MERC_LINHA,
			A.COMPRA_POR_SUPRIMENTO	=CASE WHEN @FLAGCONTROLETIPOCOMPRAFILIAL = 0 THEN ISNULL(P.COMPRA_POR_SUPRIMENTO,0) ELSE ISNULL(CPL.COMPRA_POR_SUPRIMENTO,0) END,
			A.LJ_FLAG_PARTIC_INDIC	=CASE WHEN F.FLAG_NAO_PARTIC_INDIC = 0 THEN 1 ELSE 0 END,
			A.FLAG_ANALISE_FALTAS	=P.FLAG_ANALISE_FALTAS,
			A.STS_PROD_EMP			=p.STS_PROD,
			A.STS_PROD_FILIAL		=CPL.STS_PROD,
			A.EMAX					=CPL.EMAX,
			A.ESEG					=CPL.ESEG,
			A.QTDE_FACEAMENTO		=CPL.QTDE_FACEAMENTO,
			A.QTDE_FINANCIADO		=CPL.QTDE_FINANCIADO,
			A.QTDE_LIMITADOR		=CPL.QTDE_LIMITADOR,
			A.VLR_CUSTO				=CPL.VLR_CUSTO,
			A.VLR_CUSTO_MD			=CPL.VLR_CUSTO_MD,
			A.VLR_TABELA			=vlr.VLR_TABELA,
			A.VLR_OFERTA			=vlr.VLR_OFERTA,
			A.FLAG_NAO_PARTIC_INDIC_LINHA = ISNULL(linha.FLAG_NAO_PARTIC_INDIC,0)
		FROM 
			EST_PROD_CPL_ANALISE_DIARIO_analise a 
			INNER JOIN  EST_PROD p ON
			a.CD_EMP	= p.CD_EMP AND 
			a.CD_PROD	= p.CD_PROD 
			INNER JOIN  EST_PROD_CPL CPL ON
			a.CD_EMP	= CPL.CD_EMP AND 
			a.CD_FILIAL = CPL.CD_FILIAL AND
			a.CD_PROD	= CPL.CD_PROD 
			INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA arv ON
			a.CD_EMP	= arv.CD_EMP AND 
			a.CD_PROD	= arv.CD_PROD 
			INNER JOIN  EST_ARV_MERC_LINHA linha ON
			arv.CD_EMP	= linha.CD_EMP AND 
			arv.CD_ARV_MERC_LINHA = linha.CD_ARV_MERC_LINHA 	
			join  #RS_RETORNO T on 			
			a.CD_PROD	= t.CD_PROD 			
			--CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,2) E
			--CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,3) g
			INNER JOIN  EST_PROD_PRECO vlr ON
			a.CD_EMP		= vlr.CD_EMP AND 
			a.CD_FILIAL		= vlr.CD_FILIAL AND
			a.CD_PROD		= vlr.CD_PROD  
			INNER JOIN  PRC_FILIAL f ON
			a.CD_EMP		= f.CD_EMP AND 
			a.CD_FILIAL		= f.CD_FILIAL  
		WHERE 
			a.DT_VD			=@DT_ATUAL 
			AND a.CD_EMP	=@CD_EMP
			AND a.CD_FILIAL	=@CD_FILIAL; 
	END
	ELSE
	BEGIN
		UPDATE a SET 
			a.FLAG_PART_INDIC	=	p.FLAG_ANALISE_EXC_COB,
			a.QT_EST			=	c.QT_EST,
			a.QT_EST_EM_TERC	=	c.QT_EST_EM_TERC,	
			a.QT_EST_DE_TERC	=	c.QT_EST_DE_TERC,	
			a.QT_EST_DEPOSITOS	=	c.QT_EST_DEPOSITOS,
			a.MEDIAF			=	c.MEDIAF,
			a.QT_PEND_ENT		=	ISNULL(c.QT_PEND_ENT,0),
			a.QT_PEND_SAI		=	ISNULL(c.QT_PEND_SAI,0),
			a.QT_RESSUP_DIA		=	0,
			a.QT_CP_DIA			=	0,
			a.CD_SIGLA			=	c.CD_SIGLA,
			A.QT_RESSUP_PROX_DIA=	0,
			A.CD_FABRIC				=p.CD_FABRIC,
			A.CD_ARV_MERC_LINHA		=arv.CD_ARV_MERC_LINHA,
			A.COMPRA_POR_SUPRIMENTO	=CASE WHEN @FLAGCONTROLETIPOCOMPRAFILIAL = 0 THEN ISNULL(P.COMPRA_POR_SUPRIMENTO,0) ELSE ISNULL(C.COMPRA_POR_SUPRIMENTO,0) END,
			A.LJ_FLAG_PARTIC_INDIC	=CASE WHEN F.FLAG_NAO_PARTIC_INDIC = 0 THEN 1 ELSE 0 END,
			A.FLAG_ANALISE_FALTAS	=P.FLAG_ANALISE_FALTAS,
			A.STS_PROD_EMP			=p.STS_PROD,
			A.STS_PROD_FILIAL		=C.STS_PROD_FILIAL,
			A.EMAX					=c.EMAX,
			A.ESEG					=c.ESEG,
			A.QTDE_FACEAMENTO		=C.QTDE_FACEAMENTO,
			A.QTDE_FINANCIADO		=C.QTDE_FINANCIADO,
			A.QTDE_LIMITADOR		=C.QTDE_LIMITADOR,
			A.VLR_CUSTO				=C.VLR_CUSTO,
			A.VLR_CUSTO_MD			=C.VLR_CUSTO_MD,
			A.VLR_TABELA			=vlr.VLR_TABELA ,
			A.VLR_OFERTA			=vlr.VLR_OFERTA,
			A.FLAG_NAO_PARTIC_INDIC_LINHA= ISNULL(linha.FLAG_NAO_PARTIC_INDIC,0)
		FROM 
			EST_PROD_CPL_ANALISE_DIARIO_analise a 
			INNER JOIN  EST_PROD p ON
			a.CD_EMP	= p.CD_EMP AND 
			a.CD_PROD	= p.CD_PROD 
			INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA arv ON
			a.CD_EMP	= arv.CD_EMP AND 
			a.CD_PROD	= arv.CD_PROD 
			INNER JOIN  EST_ARV_MERC_LINHA linha ON
			arv.CD_EMP	= linha.CD_EMP AND 
			arv.CD_ARV_MERC_LINHA = linha.CD_ARV_MERC_LINHA 	
			INNER JOIN  V_EST_PROD_CPL_ESTOQUE c ON
			a.CD_EMP		= c.CD_EMP AND 
			a.CD_FILIAL		= c.CD_FILIAL AND
			a.CD_PROD		= c.CD_PROD  
			INNER JOIN  EST_PROD_PRECO vlr ON
			a.CD_EMP		= vlr.CD_EMP AND 
			a.CD_FILIAL		= vlr.CD_FILIAL AND
			a.CD_PROD		= vlr.CD_PROD  
			INNER JOIN  PRC_FILIAL f ON
			a.CD_EMP		= f.CD_EMP AND 
			a.CD_FILIAL		= f.CD_FILIAL  
		WHERE 
			a.DT_VD			=@DT_ATUAL 
			AND a.CD_EMP	=@CD_EMP
			AND a.CD_FILIAL	=@CD_FILIAL; 
	END

/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
 PRINT 'Registra se o produto participa dos indicadores 2 ' + CONVERT(VARCHAR,GETDATE())	  
	UPDATE a SET 
		QT_RESSUP_DIA =	res.QT_RESSUP
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_analise a 
		INNER JOIN (SELECT 
						EST_PROD_TRANSF_IT.CD_EMP,
						EST_PROD_TRANSF_IT.CD_PROD,
						EST_PROD_TRANSF.CD_FIL_DEST CD_FILIAL,
						SUM (EST_PROD_TRANSF_IT.QT_SOL) QT_RESSUP
					FROM 
						EST_PROD_TRANSF_IT INNER JOIN EST_PROD_TRANSF ON 
						EST_PROD_TRANSF_IT.CD_EMP	 = EST_PROD_TRANSF.CD_EMP AND 
						EST_PROD_TRANSF_IT.CD_FILIAL = EST_PROD_TRANSF.CD_FILIAL AND 
						EST_PROD_TRANSF_IT.CD_CTR	 = EST_PROD_TRANSF.CD_CTR 
					WHERE 
						EST_PROD_TRANSF.DT_TRANSF = @DT_ATUAL
						AND EST_PROD_TRANSF.CD_EMP= @CD_EMP 
						AND EST_PROD_TRANSF.CD_FIL_DEST = @CD_FILIAL
					GROUP BY 
						EST_PROD_TRANSF_IT.CD_EMP,	
						EST_PROD_TRANSF_IT.CD_PROD,
						EST_PROD_TRANSF.CD_FIL_DEST) res ON 
		a.CD_EMP		= res.CD_EMP AND 
		a.CD_FILIAL		= res.CD_FILIAL AND
		a.CD_PROD		= res.CD_PROD 

	WHERE 
		a.DT_VD			=@DT_ATUAL 
		AND a.CD_EMP	=@CD_EMP
		AND a.CD_FILIAL	=@CD_FILIAL; 

---------------------------------------------------------------------------------------------------------------------------------	
	PRINT 'Registra se o produto participa dos indicadores 3 ' + CONVERT(VARCHAR,GETDATE())	  

	UPDATE a SET 
		QT_RESSUP_PROX_DIA = res.QT_RESSUP
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_analise a 
		INNER JOIN ( SELECT 
						EST_PROD_TRANSF_IT.CD_EMP,
						EST_PROD_TRANSF_IT.CD_PROD,
						EST_PROD_TRANSF.CD_FIL_DEST CD_FILIAL,
						SUM (EST_PROD_TRANSF_IT.QT_SOL) QT_RESSUP
					FROM 
						EST_PROD_TRANSF_IT INNER JOIN EST_PROD_TRANSF ON 
						EST_PROD_TRANSF_IT.CD_EMP	 = EST_PROD_TRANSF.CD_EMP AND 
						EST_PROD_TRANSF_IT.CD_FILIAL = EST_PROD_TRANSF.CD_FILIAL AND 
						EST_PROD_TRANSF_IT.CD_CTR	 = EST_PROD_TRANSF.CD_CTR 
					WHERE 
						EST_PROD_TRANSF.DT_TRANSF = @DT_ATUAL + 1
						AND EST_PROD_TRANSF.CD_EMP= @CD_EMP 
						AND EST_PROD_TRANSF.CD_FIL_DEST = @CD_FILIAL
					GROUP BY 
						EST_PROD_TRANSF_IT.CD_EMP,	
						EST_PROD_TRANSF_IT.CD_PROD,
						EST_PROD_TRANSF.CD_FIL_DEST) res ON 
		a.CD_EMP		= res.CD_EMP AND 
		a.CD_FILIAL		= res.CD_FILIAL AND
		a.CD_PROD		= res.CD_PROD 

	WHERE 
		a.DT_VD			=@DT_ATUAL
		AND a.CD_EMP	=@CD_EMP
		AND a.CD_FILIAL	=@CD_FILIAL;
 
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
 
 PRINT 'Registra se o produto participa dos indicadores 4 ' + CONVERT(VARCHAR,GETDATE())	  
	UPDATE a SET 
		QT_CP_DIA =	cp.QT_CP
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_analise a 
		INNER JOIN (SELECT     
						EST_PED_CP.CD_EMP, 
						EST_PED_CP.CD_FILIAL, 
						IT.CD_PROD,
						SUM(IT.QT_IT) QT_CP
					FROM    
						 EST_PED_CP  EST_PED_CP						
						INNER JOIN  EST_PED_CP_IT IT ON
						EST_PED_CP.CD_EMP		= IT.CD_EMP AND
						EST_PED_CP.CD_FILIAL	= IT.CD_FILIAL AND
						EST_PED_CP.CD_PED		= IT.CD_PED					
					WHERE   
						EST_PED_CP.STS_PED <> 2
						AND EST_PED_CP.CD_EMP	 = @CD_EMP
						AND EST_PED_CP.CD_FILIAL = @CD_FILIAL
						AND EST_PED_CP.DT_EMI	 = @DT_ATUAL
					GROUP BY 
						EST_PED_CP.CD_EMP, 
						EST_PED_CP.CD_FILIAL, 
						IT.CD_PROD)  cp ON 
						a.CD_EMP		= cp.CD_EMP AND 
						a.CD_FILIAL		= cp.CD_FILIAL AND
						a.CD_PROD		= cp.CD_PROD 
			WHERE 
				a.DT_VD			=@DT_ATUAL 
				AND a.CD_EMP	=@CD_EMP
				AND a.CD_FILIAL	=@CD_FILIAL;
 
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
 
	PRINT 'Gerando Excesso ' + CONVERT(VARCHAR,GETDATE())	  
--Gerando Excesso
	IF (DATEADD(DAY, -2, GETDATE()) < @DT_ATUAL)
	BEGIN
		INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_excesso	
		SELECT	
			@CD_EMP AS CD_EMP, 
			c.CD_FILIAL, 
			@DT_ATUAL AS DT_ATUAL, 
			c.CD_PROD, 
			s.DS_SIGLA AS CURVA, 
			c.MEDIAF AS QT_MEDIA, 
			ROUND(CASE WHEN c.MEDIAF > 0 THEN 
					((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0)) / (c.MEDIAF)) * 30
				ELSE 
					CONVERT(FLOAT, ((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0)) / 0.001))
				END, 2 ) AS COBERTURA,
			c.QT_EST, 
			0 AS QTDE_EXCESSO,
			c.EMAX LIMITE_EXCESSO,
			c.QT_EST_EM_TERC ,	
			c.QT_EST_DE_TERC ,	
			c.QT_EST_DEPOSITOS ,
			c.MEDIAF,
			0 QT_PEND_ENT,			
			0 QT_PEND_SAI,
			0 QT_DIAS_EXCESSO
		FROM 
			 V_EST_PROD_CPL_ESTOQUE c
			INNER JOIN  EST_PROD_CURVA_SIGLA s ON 
			c.CD_EMP = s.CD_EMP AND 
			c.CD_SIGLA = s.CD_SIGLA
		WHERE 
			c.CD_EMP		=@CD_EMP 
			AND c.CD_FILIAL = @CD_FILIAL;
	END
	ELSE
	BEGIN
		INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_excesso	
		SELECT	
			@CD_EMP AS CD_EMP, 
			c.CD_FILIAL, 
			@DT_ATUAL AS DT_ATUAL, 
			c.CD_PROD, 
			s.DS_SIGLA AS CURVA, 
			c.MEDIAF AS QT_MEDIA, 
			ROUND(CASE WHEN c.MEDIAF > 0 THEN 
					(isnull(t.QT_IT ,0)  / (c.MEDIAF)) * 30
				ELSE 
					CONVERT(FLOAT, ((isnull(t.QT_IT ,0)) / 0.001))
				END, 2 ) AS COBERTURA,
			t.QT_IT, 
			0 AS QTDE_EXCESSO,
			c.EMAX LIMITE_EXCESSO,
			0 QT_IT ,	
			0 QT_IT ,	
			c.QT_EST_DEPOSITOS ,
			c.MEDIAF,
			0 QT_PEND_ENT,			
			0 QT_PEND_SAI,
			0 QT_DIAS_EXCESSO
		FROM 
			 V_EST_PROD_CPL_ESTOQUE c
			INNER JOIN  EST_PROD_CURVA_SIGLA s ON 
			c.CD_EMP = s.CD_EMP AND 
			c.CD_SIGLA = s.CD_SIGLA
			join  #RS_RETORNO T on 			
			c.CD_PROD	= t.CD_PROD

			--CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,0) D
			--CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,2) E
			--CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,3) F
		WHERE 
			c.CD_EMP		=@CD_EMP 
			AND c.CD_FILIAL = @CD_FILIAL;
	END
---------------------------------------------------------------------------------------------------------------------------------
	PRINT 'Gerando Excesso 2  ' + CONVERT(VARCHAR,GETDATE())	  

	UPDATE 
		a 
	SET 
		COBERTURA		=e.COBERTURA, 
		QT_EST			=e.QT_EST, 
		LIMITE_EXCESSO	=e.EMAX, 
		QT_MEDIA_VD		=e.MEDIAF,
		QT_EXCESSO	    = CASE WHEN e.MEDIAF = 0 AND e.QT_EST > 0 THEN 
								e.QT_EST
							WHEN e.QT_EST > ((e.MEDIAF/30.0000) *  e.EMAX) THEN 
								ROUND(e.QT_EST - ((e.MEDIAF/30.0000) *  e.EMAX),0) 
							ELSE 
								0 
							END, 
		QT_DIAS_EXCESSO =	CASE WHEN e.MEDIAF = 0 AND e.QT_EST > 0 THEN 
								120		
							WHEN e.COBERTURA > e.EMAX THEN 
								ROUND((e.COBERTURA-e.EMAX) ,0) 
							ELSE 
								0 
							END
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_excesso e 
		INNER JOIN EST_PROD_CPL_ANALISE_DIARIO_analise a ON 
		e.CD_EMP=a.CD_EMP AND 
		e.CD_FILIAL=a.CD_FILIAL AND 
		e.CD_PROD=a.CD_PROD AND 
		e.DT_ATUAL=a.DT_VD;

---------------------------------------------------------------------------------------------------------------------------------
	PRINT 'INSERT EST_PROD_CPL_ANALISE_DIARIO ' + CONVERT(VARCHAR,GETDATE())	  
		
	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO (CD_EMP,CD_FILIAL,DT_VD,CD_PROD, PART_QTDE,QT_VD_DIA, 
							QT_MEDIA_VD,PART_VLR, VLR_MEDIO_VD,COBERTURA,QT_EST,QT_EXCESSO,LIMITE_EXCESSO,FLAG_PART_INDIC,QT_EST_EM_TERC ,	
							QT_EST_DE_TERC,QT_EST_DEPOSITOS ,MEDIAF,QT_PEND_ENT,QT_PEND_SAI,QT_RESSUP_DIA,
							QT_CP_DIA,CD_SIGLA, VLR_DESC_VD,QT_DIAS_EXCESSO,QT_RESSUP_PROX_DIA,CD_FABRIC,CD_ARV_MERC_LINHA, 
							COMPRA_POR_SUPRIMENTO,LJ_FLAG_PARTIC_INDIC,FLAG_ANALISE_FALTAS,
							STS_PROD_EMP,STS_PROD_FILIAL,EMAX,ESEG,QTDE_FACEAMENTO,QTDE_FINANCIADO,QTDE_LIMITADOR, DT_CAD,
							VLR_CUSTO,VLR_CUSTO_MD,VLR_TABELA,VLR_OFERTA,FLAG_NAO_PARTIC_INDIC_LINHA)
	
	SELECT
		   CD_EMP
		 , CD_FILIAL
		 , DT_VD
		 , CD_PROD
		 , PART_QTDE
		 , QT_VD_DIA
		 , QT_MEDIA_VD
		 , PART_VLR
		 , VLR_MEDIO_VD
		 , ISNULL(COBERTURA, 0)
		 , ISNULL(QT_EST, 0)
		 , ISNULL(QT_EXCESSO, 0)
		 , ISNULL(LIMITE_EXCESSO, 0)
		 , ISNULL(FLAG_PART_INDIC, 0)
		 , ISNULL(QT_EST_EM_TERC, 0)
		 , ISNULL(QT_EST_DE_TERC, 0)
		 , ISNULL(QT_EST_DEPOSITOS, 0)
		 , ISNULL(MEDIAF, 0)
		 , ISNULL(QT_PEND_ENT, 0)
		 , ISNULL(QT_PEND_SAI, 0)
		 , ISNULL(QT_RESSUP_DIA, 0)
		 , ISNULL(QT_CP_DIA, 0)
		 , ISNULL(CD_SIGLA, 0)
		 , ISNULL(VLR_DESC_VD, 0)
		 , ISNULL(QT_DIAS_EXCESSO, 0)
		 , ISNULL(QT_RESSUP_PROX_DIA, 0)
		 , ISNULL(CD_FABRIC, 0)
		 , ISNULL(CD_ARV_MERC_LINHA, 0)
		 , ISNULL(COMPRA_POR_SUPRIMENTO, 0)
		 , ISNULL(LJ_FLAG_PARTIC_INDIC, 0)
		 , ISNULL(FLAG_ANALISE_FALTAS, 0)
		 , ISNULL(STS_PROD_EMP, 0)
		 , ISNULL(STS_PROD_FILIAL, 0)
		 , ISNULL(EMAX, 0)
		 , ISNULL(ESEG, 0)
		 , ISNULL(QTDE_FACEAMENTO, 0)
		 , ISNULL(QTDE_FINANCIADO, 0)
		 , ISNULL(QTDE_LIMITADOR, 0)
		 , GETDATE()
		 , ISNULL(VLR_CUSTO, 0)
		 , ISNULL(VLR_CUSTO_MD, 0)
		 , ISNULL(VLR_TABELA, 0)
		 , ISNULL(VLR_OFERTA, 0)
		 , FLAG_NAO_PARTIC_INDIC_LINHA
	FROM
		EST_PROD_CPL_ANALISE_DIARIO_analise
	WHERE  DT_VD = @DT_ATUAL
		   AND CD_EMP = @CD_EMP
		   AND CD_FILIAL = @CD_FILIAL;
 
   
	SELECT
		@DT_INI_MES=dbo.F_INICIO_MES(@DT_ATUAL),
		@DT_FIM_MES= @DT_INI_MES;

-----------------------------------------------------------------------------------------------------------------------

	PRINT 'INSERT EST_PROD_CPL_ANALISE_DIARIO_base2 ' + CONVERT(VARCHAR,GETDATE())	  
	WHILE @DT_FIM_MES <= @DT_ATUAL
	BEGIN 
	   
		INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_base2
		SELECT  
			 CD_FILIAL, 
			 CD_PROD,
			 CASE WHEN QT_EST > 1 THEN	1 
				    WHEN QT_EST < 1 THEN 0 
			 END AS QT_DIAS_CALCULO,
			 CASE WHEN  QT_EST >1 THEN 0  WHEN  QT_EST >1
				    THEN 1 END AS QT_DIAS_FALTA
		  FROM 
			 EST_PROD_CPL_ANALISE_DIARIO 
		  WHERE 
			 CD_EMP=@CD_EMP				
			 AND CD_FILIAL =@CD_FILIAL 				
			 AND DT_VD = @DT_FIM_MES

			SET @DT_FIM_MES = @DT_FIM_MES +1
		END

-----------------------------------------------------------------------------------------------------------------------
 	PRINT 'INSERT EST_PROD_CPL_ANALISE_DIARIO_base  ' + CONVERT(VARCHAR,GETDATE())	  
	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO_base
	SELECT  
		CD_FILIAL, 
		CD_PROD, 
		SUM (QT_DIAS_CALCULO) QT_DIAS_CALCULO ,
		SUM (QT_DIAS_FALTA ) QT_DIAS_FALTA
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO_base2
	GROUP BY 	
		CD_FILIAL, 
		CD_PROD;
		 
-----------------------------------------------------------------------------------------------------------------------

    PRINT 'UPDATE EST_PROD_CPL_ANALISE ' + CONVERT(VARCHAR,GETDATE())	  	 
	UPDATE 
		m 
	SET 
		QT_DIAS_FALTA=ISNULL(d.QT_DIAS_FALTA,0), 
		QT_DIAS_CALCULO=ISNULL(d.QT_DIAS_CALCULO,0),
		DT_CALCULO_DIARIO=GETDATE()
	FROM 
		EST_PROD_CPL_ANALISE m 
		INNER JOIN EST_PROD_CPL_ANALISE_DIARIO_base d ON 
		d.CD_FILIAL	= m.CD_FILIAL AND 
		d.CD_PROD	= m.CD_PROD 
	WHERE 
		m.CD_EMP=@CD_EMP 
		AND m.CD_FILIAL=@CD_FILIAL
		AND m.MES=MONTH(@DT_ATUAL)
		AND m.ANO=YEAR(@DT_ATUAL) ;

-----------------------------------------------------------------------------------------------------------------------

	PRINT 'FIM EST_PROD_CPL_ANALISE ' + CONVERT(VARCHAR,GETDATE())	 